/*
 * Decompiled with CFR 0.152.
 */
package reliquary.handler;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import reliquary.blocks.PassivePedestalBlock;
import reliquary.handler.HandlerPriorityComparator;
import reliquary.handler.IPlayerDeathHandler;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.RendingGaleItem;
import reliquary.pedestal.PedestalRegistry;
import reliquary.util.XRFakePlayerFactory;

public class CommonEventHandler {
    private static final Set<IPlayerHurtHandler> playerHurtHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static final Set<IPlayerDeathHandler> playerDeathHandlers = Sets.newTreeSet((Comparator)new HandlerPriorityComparator());
    private static final Map<UUID, Boolean> playersFlightStatus = new HashMap<UUID, Boolean>();

    private CommonEventHandler() {
    }

    public static void registerPlayerHurtHandler(IPlayerHurtHandler handler) {
        playerHurtHandlers.add(handler);
    }

    public static void registerPlayerDeathHandler(IPlayerDeathHandler handler) {
        playerDeathHandlers.add(handler);
    }

    public static void registerEventBusListeners(IEventBus eventBus) {
        eventBus.addListener(PassivePedestalBlock::onRightClicked);
        eventBus.addListener(CommonEventHandler::preventMendingAndUnbreaking);
        eventBus.addListener(CommonEventHandler::blameDrullkus);
        eventBus.addListener(CommonEventHandler::beforePlayerHurt);
        eventBus.addListener(CommonEventHandler::beforePlayerDeath);
        eventBus.addListener(CommonEventHandler::onDimensionUnload);
        eventBus.addListener(CommonEventHandler::onPlayerTick);
        eventBus.addListener(PedestalRegistry::serverStopping);
    }

    public static void preventMendingAndUnbreaking(AnvilUpdateEvent event) {
        if (event.getLeft().m_41619_() || event.getRight().m_41619_()) {
            return;
        }
        if (event.getLeft().m_41720_() != ModItems.MOB_CHARM.get() && event.getLeft().m_41720_() != ModItems.ALKAHESTRY_TOME.get()) {
            return;
        }
        if (EnchantmentHelper.m_44831_((ItemStack)event.getRight()).keySet().stream().anyMatch(e -> e == Enchantments.f_44986_)) {
            event.setCanceled(true);
        }
    }

    public static void blameDrullkus(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().m_36316_().getName().equals("Drullkus") && !event.getPlayer().getPersistentData().m_128441_("gift") && event.getPlayer().m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.WITCH_HAT.get()))) {
            event.getPlayer().getPersistentData().m_128379_("gift", true);
        }
    }

    public static void beforePlayerHurt(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean cancel = false;
        for (IPlayerHurtHandler handler : playerHurtHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    public static void beforePlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean cancel = false;
        for (IPlayerDeathHandler handler : playerDeathHandlers) {
            if (!handler.canApply(player, event) || !handler.apply(player, event)) continue;
            cancel = true;
            break;
        }
        if (cancel) {
            event.setCanceled(true);
            event.setResult(null);
        }
    }

    public static void onDimensionUnload(WorldEvent.Unload event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            XRFakePlayerFactory.unloadWorld(serverLevel);
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (player.m_6117_() && player.m_21211_().m_41720_() == ModItems.RENDING_GALE.get() && ((RendingGaleItem)ModItems.RENDING_GALE.get()).getMode(player.m_21211_()) == RendingGaleItem.Mode.FLIGHT && ((RendingGaleItem)ModItems.RENDING_GALE.get()).hasFlightCharge(player.m_21211_())) {
            playersFlightStatus.put(player.m_36316_().getId(), true);
            player.m_150110_().f_35936_ = true;
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
        } else {
            if (!playersFlightStatus.containsKey(player.m_36316_().getId())) {
                playersFlightStatus.put(player.m_36316_().getId(), false);
                return;
            }
            boolean isFlying = playersFlightStatus.get(player.m_36316_().getId());
            if (isFlying) {
                playersFlightStatus.put(player.m_36316_().getId(), false);
                if (!player.m_7500_()) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
                }
            }
        }
    }
}

